/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.unusualfishmod.client.misc.render;

import codyhuh.unusualfishmod.common.entity.item.FallingTreeBlockEntity;
import codyhuh.unusualfishmod.common.entity.util.misc.MovingBlockData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FallingTreeBlockRenderer
extends EntityRenderer<FallingTreeBlockEntity> {
    public FallingTreeBlockRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.5f;
    }

    public void render(FallingTreeBlockEntity entity, float f1, float f2, PoseStack stack, MultiBufferSource source, int i) {
        stack.m_85836_();
        float fallProgress = entity.getFallProgress(f2);
        this.rotateBasedOnDirection(stack, entity.getFallDirection(), fallProgress * fallProgress * 90.0f);
        stack.m_85836_();
        for (MovingBlockData data : entity.getData()) {
            BlockState blockstate = data.getState();
            if (blockstate.m_60799_() == RenderShape.INVISIBLE) continue;
            stack.m_85836_();
            stack.m_85837_(-0.5, -0.5, -0.5);
            stack.m_252880_((float)data.getOffset().m_123341_(), (float)data.getOffset().m_123342_(), (float)data.getOffset().m_123343_());
            if (blockstate.m_60799_() == RenderShape.ENTITYBLOCK_ANIMATED && blockstate.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
                float f = ((Direction)blockstate.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122435_();
                stack.m_85837_(0.5, 0.5, 0.5);
                stack.m_252781_(Axis.f_252436_.m_252977_(-f));
                stack.m_85837_(-0.5, -0.5, -0.5);
            }
            Minecraft.m_91087_().m_91289_().m_110912_(blockstate, stack, source, i, OverlayTexture.f_118083_);
            stack.m_85849_();
        }
        stack.m_85849_();
        stack.m_85849_();
        super.m_7392_((Entity)entity, f1, f2, stack, source, i);
    }

    private void rotateBasedOnDirection(PoseStack poseStack, Direction fallDirection, float f) {
        switch (fallDirection) {
            case NORTH: {
                poseStack.m_252781_(Axis.f_252495_.m_252977_(f));
                break;
            }
            case SOUTH: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(f));
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252393_.m_252977_(f));
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(f));
            }
        }
    }

    public ResourceLocation getTextureLocation(FallingTreeBlockEntity entity) {
        return TextureAtlas.f_118259_;
    }
}

